% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2_line_layer_processor.R
\name{Ggplot2LineLayerProcessor}
\alias{Ggplot2LineLayerProcessor}
\title{Final Line Layer Processor - Uses Actual SVG Structure}
\description{
Processes line plot layers using the actual gridSVG structure discovered:
- Lines: GRID.polyline.61.1.1, GRID.polyline.61.1.2, GRID.polyline.61.1.3
- Points: geom_point.points.63.1.1 through geom_point.points.63.1.24 (grouped by series)
}
\keyword{Process}
\keyword{SVG}
\keyword{actual}
\keyword{internal}
\keyword{layer}
\keyword{line}
\keyword{structure}
\keyword{the}
\keyword{with}
\section{Super class}{
\code{\link[maidr:LayerProcessor]{maidr::LayerProcessor}} -> \code{Ggplot2LineLayerProcessor}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{layer_info}}{Information about the layer being processed}

\item{\code{last_result}}{The last processing result}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{layer_info}}{Information about the layer being processed}

\item{\code{last_result}}{The last processing result}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Ggplot2LineLayerProcessor-process}{\code{Ggplot2LineLayerProcessor$process()}}
\item \href{#method-Ggplot2LineLayerProcessor-extract_data}{\code{Ggplot2LineLayerProcessor$extract_data()}}
\item \href{#method-Ggplot2LineLayerProcessor-extract_multiline_data}{\code{Ggplot2LineLayerProcessor$extract_multiline_data()}}
\item \href{#method-Ggplot2LineLayerProcessor-extract_single_line_data}{\code{Ggplot2LineLayerProcessor$extract_single_line_data()}}
\item \href{#method-Ggplot2LineLayerProcessor-get_group_column}{\code{Ggplot2LineLayerProcessor$get_group_column()}}
\item \href{#method-Ggplot2LineLayerProcessor-generate_selectors}{\code{Ggplot2LineLayerProcessor$generate_selectors()}}
\item \href{#method-Ggplot2LineLayerProcessor-generate_multiline_selectors}{\code{Ggplot2LineLayerProcessor$generate_multiline_selectors()}}
\item \href{#method-Ggplot2LineLayerProcessor-generate_single_line_selector}{\code{Ggplot2LineLayerProcessor$generate_single_line_selector()}}
\item \href{#method-Ggplot2LineLayerProcessor-find_main_polyline_grob}{\code{Ggplot2LineLayerProcessor$find_main_polyline_grob()}}
\item \href{#method-Ggplot2LineLayerProcessor-needs_reordering}{\code{Ggplot2LineLayerProcessor$needs_reordering()}}
\item \href{#method-Ggplot2LineLayerProcessor-clone}{\code{Ggplot2LineLayerProcessor$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="apply_scale_mapping"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-apply_scale_mapping'><code>maidr::LayerProcessor$apply_scale_mapping()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="extract_layer_axes"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-extract_layer_axes'><code>maidr::LayerProcessor$extract_layer_axes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="get_last_result"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-get_last_result'><code>maidr::LayerProcessor$get_last_result()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="get_layer_index"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-get_layer_index'><code>maidr::LayerProcessor$get_layer_index()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="initialize"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-initialize'><code>maidr::LayerProcessor$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="reorder_layer_data"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-reorder_layer_data'><code>maidr::LayerProcessor$reorder_layer_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="set_last_result"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-set_last_result'><code>maidr::LayerProcessor$set_last_result()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2LineLayerProcessor-process"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2LineLayerProcessor-process}{}}}
\subsection{Method \code{process()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2LineLayerProcessor$process(
  plot,
  layout,
  built = NULL,
  gt = NULL,
  scale_mapping = NULL,
  grob_id = NULL,
  panel_id = NULL,
  panel_ctx = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot}}{The ggplot2 object}

\item{\code{layout}}{Layout information}

\item{\code{built}}{Built plot data (optional)}

\item{\code{gt}}{Gtable object (optional)}

\item{\code{scale_mapping}}{Scale mapping for faceted plots (optional)}

\item{\code{grob_id}}{Grob ID for faceted plots (optional)}

\item{\code{panel_id}}{Panel ID for faceted plots (optional)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List with data and selectors
Extract data from line layer (single or multiline)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2LineLayerProcessor-extract_data"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2LineLayerProcessor-extract_data}{}}}
\subsection{Method \code{extract_data()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2LineLayerProcessor$extract_data(
  plot,
  built = NULL,
  scale_mapping = NULL,
  panel_id = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot}}{The ggplot2 object}

\item{\code{built}}{Built plot data (optional)}

\item{\code{scale_mapping}}{Scale mapping for faceted plots (optional)}

\item{\code{panel_id}}{Panel ID for faceted plots (optional)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of arrays, each containing series data points
Extract data for multiple line series
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2LineLayerProcessor-extract_multiline_data"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2LineLayerProcessor-extract_multiline_data}{}}}
\subsection{Method \code{extract_multiline_data()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2LineLayerProcessor$extract_multiline_data(layer_data, plot)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{layer_data}}{The built layer data}

\item{\code{plot}}{The original ggplot2 object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of arrays, each containing series data
Extract data for single line (backward compatibility)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2LineLayerProcessor-extract_single_line_data"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2LineLayerProcessor-extract_single_line_data}{}}}
\subsection{Method \code{extract_single_line_data()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2LineLayerProcessor$extract_single_line_data(layer_data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{layer_data}}{The built layer data}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List containing single series data
Get the grouping column name from plot mappings
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2LineLayerProcessor-get_group_column"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2LineLayerProcessor-get_group_column}{}}}
\subsection{Method \code{get_group_column()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2LineLayerProcessor$get_group_column(plot)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot}}{The ggplot2 object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Name of the grouping column
Generate selectors using actual SVG structure
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2LineLayerProcessor-generate_selectors"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2LineLayerProcessor-generate_selectors}{}}}
\subsection{Method \code{generate_selectors()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2LineLayerProcessor$generate_selectors(
  plot,
  gt = NULL,
  grob_id = NULL,
  panel_ctx = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot}}{The ggplot2 object}

\item{\code{gt}}{Gtable object (optional)}

\item{\code{grob_id}}{Grob ID for faceted plots (optional)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of selectors for each series
Generate selectors for multiline plots using actual structure
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2LineLayerProcessor-generate_multiline_selectors"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2LineLayerProcessor-generate_multiline_selectors}{}}}
\subsection{Method \code{generate_multiline_selectors()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2LineLayerProcessor$generate_multiline_selectors(base_id, num_series)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_id}}{The base ID from the grob (e.g., "61")}

\item{\code{num_series}}{Number of series}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of selectors
Generate selector for single line plot
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2LineLayerProcessor-generate_single_line_selector"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2LineLayerProcessor-generate_single_line_selector}{}}}
\subsection{Method \code{generate_single_line_selector()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2LineLayerProcessor$generate_single_line_selector(base_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_id}}{The base ID from the grob}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List with single selector
Find the main polyline grob (GRID.polyline.XX)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2LineLayerProcessor-find_main_polyline_grob"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2LineLayerProcessor-find_main_polyline_grob}{}}}
\subsection{Method \code{find_main_polyline_grob()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2LineLayerProcessor$find_main_polyline_grob(gt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{gt}}{The gtable to search}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The main polyline grob or NULL
Check if layer needs reordering
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2LineLayerProcessor-needs_reordering"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2LineLayerProcessor-needs_reordering}{}}}
\subsection{Method \code{needs_reordering()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2LineLayerProcessor$needs_reordering()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
FALSE (line plots typically don't need reordering)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2LineLayerProcessor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2LineLayerProcessor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2LineLayerProcessor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
