% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_loading.R
\name{load_builtin_wwtp}
\alias{load_builtin_wwtp}
\title{Load Built-in WWTP Data from OSF}
\usage{
load_builtin_wwtp(
  nutrient,
  year = 2016,
  force_download = FALSE,
  verbose = TRUE
)

load_builtin_wwtp(
  nutrient,
  year = 2016,
  force_download = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{nutrient}{Character. "nitrogen" or "phosphorus"}

\item{year}{Numeric. Year to filter data (available: 2007-2016)}

\item{force_download}{Logical. Force re-download even if cached}

\item{verbose}{Logical. Show download progress}
}
\value{
Data frame with cleaned WWTP data for specified year

Data frame with cleaned WWTP data for specified year
}
\description{
Load built-in WWTP data for specified year from OSF repository (2007-2016 available)

Load built-in WWTP data for specified year from OSF repository (2007-2016 available)
}
\examples{
\donttest{
# Load WWTP data for different years (2007-2016 available)
wwtp_n_2016 <- load_builtin_wwtp("nitrogen", 2016)
wwtp_n_2012 <- load_builtin_wwtp("nitrogen", 2012)
wwtp_n_2007 <- load_builtin_wwtp("nitrogen", 2007)

# Load phosphorus data
wwtp_p_2015 <- load_builtin_wwtp("phosphorus", 2015)
wwtp_p_2010 <- load_builtin_wwtp("phosphorus", 2010)

# Force re-download
wwtp_fresh <- load_builtin_wwtp("nitrogen", 2014, force_download = TRUE)
}
}
