% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp-get-grid-EEA.R
\encoding{UTF-8}
\name{esp_get_grid_EEA}
\alias{esp_get_grid_EEA}
\title{Get \code{\link[sf:sf]{sf}} \code{POLYGON} of the national geographic grids from EEA}
\source{
\href{https://www.eea.europa.eu/en/datahub/datahubitem-view/3c362237-daa4-45e2-8c16-aaadfb1a003b}{EEA reference grid}.
}
\usage{
esp_get_grid_EEA(
  resolution = 100,
  type = "main",
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE
)
}
\arguments{
\item{resolution}{Resolution of the grid in kms. Can be \code{1}, \code{10} or \code{100}.}

\item{type}{character. The geographic scope of the grid:
\itemize{
\item \code{"main"}: Mainland Spain (default)
\item \code{"canary"}: Canary Islands
}}

\item{update_cache}{logical. Should the cached file be refreshed? Default
is \code{FALSE}. When set to \code{TRUE}, it will force a new download.}

\item{cache_dir}{character string. A path to a cache directory. See
\strong{Caching strategies} section in \code{\link[=esp_set_cache_dir]{esp_set_cache_dir()}}.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}
}
\value{
A \code{\link[sf:sf]{sf}} \code{POLYGON}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#defunct}{\figure{lifecycle-defunct.svg}{options: alt='[Defunct]'}}}{\strong{[Defunct]}}

This function is defunct as the source file is not available any more.
}
\concept{deprecated functions}
\keyword{internal}
