% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{lines_from_sf}
\alias{lines_from_sf}
\title{Extract Line Coordinates from sf Objects}
\usage{
lines_from_sf(sf_obj, id_col = NULL)
}
\arguments{
\item{sf_obj}{An \code{sf} or \code{sfc} object containing \code{LINESTRING} or
\code{MULTILINESTRING} geometries.}

\item{id_col}{Character. Optional column name to use as line IDs.
If \code{NULL}, IDs are generated as \code{"ln-1"}, \code{"ln-2"}, etc.
(default = \code{NULL}).}
}
\value{
A list of lists, each containing:
\itemize{
\item \code{id}: Character identifier for the line
\item \code{coords}: List of \verb{[x, y]} coordinate pairs representing the
line vertices in sequence
}
}
\description{
Converts \code{sf} line or multiline geometries into a list structure
containing coordinate arrays, suitable for serialization to JSON
or use in JavaScript visualizations.
}
\details{
This function prepares line geometries for client-side rendering.
Multilinestrings are handled by extracting all coordinate points
in order, which may or may not be appropriate depending on the
use case.
}
\examples{
\dontrun{
library(sf)

# Create a simple linestring
line <- st_linestring(matrix(c(0,0, 1,1, 2,0), ncol = 2, byrow = TRUE))
sf_obj <- st_sf(id = "route1", geometry = st_sfc(line))

# Extract coordinates
coords <- lines_from_sf(sf_obj, id_col = "id")
str(coords)
}

}
\seealso{
\code{\link[=polygons_from_sf]{polygons_from_sf()}}, \code{\link[=points_from_sf]{points_from_sf()}}, \code{\link[=shiny_fisheye]{shiny_fisheye()}}
}
\keyword{internal}
