% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot_fisheye_fgc}
\alias{plot_fisheye_fgc}
\title{Visualize Focus–Glue–Context (FGC) Fisheye Transformation}
\usage{
plot_fisheye_fgc(
  original_coords,
  transformed_coords,
  cx = 0,
  cy = 0,
  r_in = 0.34,
  r_out = 0.5
)
}
\arguments{
\item{original_coords}{A matrix or data frame with at least two
columns representing the original \verb{(x, y)} coordinates.}

\item{transformed_coords}{A matrix or data frame with the
transformed \verb{(x, y)} coordinates (same number of rows as
\code{original_coords}).}

\item{cx, cy}{Numeric. The x and y coordinates of the fisheye
center (default = 0, 0).}

\item{r_in}{Numeric. Radius of the inner \emph{focus} boundary
(default = 0.34).}

\item{r_out}{Numeric. Radius of the outer \emph{glue} boundary
(default = 0.5).}
}
\value{
A \code{ggplot2} object showing original vs transformed
coordinates, colored by zone, with boundary circles
overlaid.
}
\description{
Creates a side-by-side scatterplot comparing the \strong{original}
and \strong{transformed} coordinates of a dataset under the
Focus–Glue–Context fisheye mapping. Points are colored
according to whether they fall in the \emph{focus}, \emph{glue}, or
\emph{context} zones, and boundary circles are drawn for clarity.
}
\examples{
library(ggplot2)

# Generate test grid and apply fisheye
grid <- create_test_grid(range = c(-1, 1), spacing = 0.1)
warped <- fisheye_fgc(grid, r_in = 0.4, r_out = 0.7)

# Visualize transformation
plot_fisheye_fgc(grid, warped, r_in = 0.4, r_out = 0.7)

}
\seealso{
\code{\link[=create_test_grid]{create_test_grid()}}, \code{\link[=fisheye_fgc]{fisheye_fgc()}}
}
