% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Recipes.R
\name{read_recipe}
\alias{read_recipe}
\title{Read Recipe}
\usage{
read_recipe(file)
}
\arguments{
\item{file}{A character string specifying the file path.}
}
\value{
A Recipe object.
}
\description{
Reads a Recipe object from a JSON file.
}
\details{
This function reads a JSON file and
decodes it into a Recipe object.
}
\examples{
r <- recipe(
  name = "Example", user = "Test",
  svy = survey_empty(type = "ech", edition = "2023"),
  description = "Example recipe"
)
f <- tempfile(fileext = ".json")
save_recipe(r, f)
r2 <- read_recipe(f)
r2
}
\seealso{
Other recipes: 
\code{\link{Recipe-class}},
\code{\link{add_recipe}()},
\code{\link{bake_recipes}()},
\code{\link{explore_recipes}()},
\code{\link{get_recipe}()},
\code{\link{print.Recipe}()},
\code{\link{publish_recipe}()},
\code{\link{recipe}()},
\code{\link{save_recipe}()},
\code{\link{steps_to_recipe}()}
}
\concept{recipes}
\keyword{utils}
