% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_exponential_thselect.R
\name{thselect.gbw}
\alias{thselect.gbw}
\title{Kernel-based threshold selection of Goegebeur, Beirlant and de Wet (2008)}
\usage{
thselect.gbw(
  xdat,
  kmax,
  kernel = c("Jackson", "Lewis"),
  rho = c("gbw", "ghp", "fagh", "dk"),
  ...
)
}
\arguments{
\item{xdat}{[vector] sample exceedances}

\item{kmax}{[int] maximum number of exceedances considered}

\item{kernel}{[string] kernel choice, one of \code{Jackson} or \code{Lewis}}

\item{rho}{string for the estimator of the second order regular variation. Can also be a negative scalar}

\item{...}{additional arguments, for backward compatibility purposes}
}
\value{
a list with elements
\itemize{
\item{\code{k0}:} number of exceedances
\item{\code{shape}:} Hill's shape estimate
\item{\code{rho}:} second-order regular variation parameter estimate
\item{\code{gof}:} goodness-of-fit statistic for the chosen threshold.
}
}
\description{
Kernel-based threshold selection of Goegebeur, Beirlant and de Wet (2008)
}
\examples{
xdat <- rgp(n = 1000, scale = 2, shape = 0.5)
(thselect.gbw(xdat, kmax = 500))
}
\references{
Goegebeur , Y., Beirlant , J., and de Wet , T. (2008). Linking Pareto-Tail Kernel Goodness-of-fit Statistics with Tail Index at Optimal Threshold and Second Order Estimation. REVSTAT-Statistical Journal, 6(\bold{1}), 51–69. <doi:10.57805/revstat.v6i1.57>
}
