% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{collect_mirai}
\alias{collect_mirai}
\title{mirai (Collect Value)}
\usage{
collect_mirai(x, options = NULL)
}
\arguments{
\item{x}{(mirai | list) a 'mirai' object or list of 'mirai' objects.}

\item{options}{(character) collection options for list input, e.g. \code{".flat"}
or \code{c(".progress", ".stop")}. See Options section.}
}
\value{
An object (the return value of the 'mirai'), or a list of such
objects (the same length as \code{x}, preserving names).
}
\description{
Waits for the 'mirai' to resolve if still in progress (blocking but
interruptible) and returns its value directly. Equivalent to
\code{call_mirai(x)$data}.
}
\details{
\code{x[]} is an equivalent way to wait for and return the value of a mirai \code{x}.
}
\section{Options}{


A named list may also be supplied instead of a character vector, where the
names are the collection options. The value for \code{.progress} is passed to the
cli progress bar: a character value sets the bar name, and a list is passed
as named parameters to \code{cli::cli_progress_bar}. Examples:
\code{c(.stop = TRUE, .progress = "bar name")} or
\code{list(.stop = TRUE, .progress = list(name = "bar", type = "tasks"))}
}

\section{Alternatively}{


The value of a 'mirai' may be accessed at any time at \verb{$data}, and if yet to
resolve, an 'unresolved' logical NA will be returned instead.

Using \code{\link[=unresolved]{unresolved()}} on a 'mirai' returns TRUE only if it has yet to resolve
and FALSE otherwise. This is suitable for use in control flow statements such
as \code{while} or \code{if}.
}

\section{Errors}{


If an error occurs in evaluation, the error message is returned as a
character string of class 'miraiError' and 'errorValue'. \code{\link[=is_mirai_error]{is_mirai_error()}}
may be used to test for this. The elements of the original condition are
accessible via \code{$} on the error object. A stack trace comprising a list of
calls is also available at \verb{$stack.trace}, and the original condition classes
at \verb{$condition.class}.

If a daemon crashes or terminates unexpectedly during evaluation, an
'errorValue' 19 (Connection reset) is returned.

\code{\link[=is_error_value]{is_error_value()}} tests for all error conditions including 'mirai' errors,
interrupts, and timeouts.
}

\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# using collect_mirai()
df1 <- data.frame(a = 1, b = 2)
df2 <- data.frame(a = 3, b = 1)
m <- mirai(as.matrix(rbind(df1, df2)), df1 = df1, df2 = df2, .timeout = 1000)
collect_mirai(m)

# using x[]
m[]

# mirai_map with collection options
daemons(1, dispatcher = FALSE)
m <- mirai_map(1:3, rnorm)
collect_mirai(m, c(".flat", ".progress"))
daemons(0)
\dontshow{\}) # examplesIf}
}
