% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/next.R
\name{nextstream}
\alias{nextstream}
\alias{nextget}
\alias{nextcode}
\title{Next >> Developer Interface}
\usage{
nextstream(.compute = "default")

nextget(x, .compute = "default")

nextcode(xc)
}
\arguments{
\item{.compute}{(character) name of the compute profile. Each profile has its
own independent set of daemons. \code{NULL} (default) uses the 'default'
profile.}

\item{x}{(character) item to retrieve: \code{"n"} (daemon count), \code{"dispatcher"}
(dispatcher-to-host URL), \code{"url"} (daemon connection URL), or \code{"tls"}
(client TLS configuration).}

\item{xc}{(integer) return value from \code{\link[=daemon]{daemon()}}.}
}
\value{
For \code{nextstream}: a length 7 integer vector, as given by
\code{.Random.seed} when the L'Ecuyer-CMRG RNG is in use (may be passed directly
to the \code{rs} argument of \code{\link[=daemon]{daemon()}}), or else NULL if a stream has not yet
been created.

For \code{nextget}: the requested item, or else NULL if not present.

For \code{nextcode}: character string.
}
\description{
\code{nextstream} retrieves the currently stored L'Ecuyer-CMRG RNG stream
for the specified compute profile and advances it to the next stream.

\code{nextget} retrieves the specified item from the specified compute profile.

\code{nextcode} translates integer exit codes returned by \code{\link[=daemon]{daemon()}}.
}
\details{
These functions are exported for use by packages extending \pkg{mirai} with
alternative launchers of \code{\link[=daemon]{daemon()}} processes.

For \code{nextstream}: Calling this function advances the stream stored within
the compute profile. This ensures that the next recursive stream is returned
on subsequent calls.
}
\examples{
daemons(sync = TRUE)
nextstream()
nextstream()

nextget("url")

daemons(0)

nextcode(0L)
nextcode(1L)

}
\keyword{internal}
