% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{race_mirai}
\alias{race_mirai}
\title{mirai (Race)}
\usage{
race_mirai(x, .compute = NULL)
}
\arguments{
\item{x}{(list) of 'mirai' objects.}

\item{.compute}{(character) name of the compute profile. Each profile has its
own independent set of daemons. \code{NULL} (default) uses the 'default'
profile.}
}
\value{
Integer index of the first resolved 'mirai' (invisibly), or
\code{0L} if the list is empty.
}
\description{
Accepts a list of 'mirai' objects, such as those returned by \code{\link[=mirai_map]{mirai_map()}}.
Returns the index of the first resolved 'mirai'. If any mirai is already
resolved, returns immediately. Otherwise waits for at least one to resolve,
blocking but user-interruptible.
}
\details{
All of the 'mirai' objects supplied must belong to the same compute profile.

When called on a list where some mirais are already resolved,
returns the index of the first resolved mirai immediately without waiting.
When all mirais are unresolved, blocks until at least one resolves. If
multiple mirais resolve during the same wait iteration, returns the
index of the first resolved in list order.

This enables an efficient "process as completed" pattern:
\preformatted{
  remaining <- list(m1, m2, m3)
  while (length(remaining) > 0) {
    idx <- race_mirai(remaining)
    process(remaining[[idx]]$data)
    remaining <- remaining[-idx]
  }
  }
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
daemons(2)
m1 <- mirai({ Sys.sleep(0.2); "one" })
m2 <- mirai({ Sys.sleep(0.1); "two" })
m3 <- mirai({ Sys.sleep(0.3); "three" })
remaining <- list(m1, m2, m3)
while (length(remaining) > 0) {
  idx <- race_mirai(remaining)
  print(remaining[[idx]]$data)
  remaining <- remaining[-idx]
}
daemons(0)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=call_mirai]{call_mirai()}}
}
