% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals-management.R
\name{gintervals.rm}
\alias{gintervals.rm}
\title{Deletes a named intervals set}
\usage{
gintervals.rm(intervals.set = NULL, force = FALSE, db = NULL)
}
\arguments{
\item{intervals.set}{name of an intervals set}

\item{force}{if 'TRUE', suppresses user confirmation of a named intervals set
removal}

\item{db}{optional database path. When multiple databases are connected,
this specifies which database to delete the intervals set from. If NULL (the
default), the intervals set is deleted from the working database (GROOT).}
}
\value{
None.
}
\description{
Deletes a named intervals set.
}
\details{
This function deletes a named intervals set from the Genomic Database. By
default 'gintervals.rm' requires the user to interactively confirm the
deletion. Set 'force' to 'TRUE' to suppress the user prompt.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
intervs <- gintervals(c(1, 2))
gintervals.save("testintervs", intervs)
gintervals.ls()
gintervals.rm("testintervs", force = TRUE)
gintervals.ls()

}
\seealso{
\code{\link{gintervals.save}}, \code{\link{gintervals.exists}},
\code{\link{gintervals.ls}}, \code{\link{gintervals}},
\code{\link{gintervals.2d}}, \code{\link{gtrack.rm}}
}
\keyword{~intervals}
