% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr_callbacks.R
\name{mlr3tuning.one_se_rule}
\alias{mlr3tuning.one_se_rule}
\title{One Standard Error Rule Callback}
\source{
Kuhn, Max, Johnson, Kjell (2013).
\dQuote{Applied Predictive Modeling.}
In chapter Over-Fitting and Model Tuning, 61--92.
Springer New York, New York, NY.
ISBN 978-1-4614-6849-3.
}
\description{
The one standard error rule takes the number of features into account when selecting the best hyperparameter configuration.
Many learners support internal feature selection, which can be accessed via \verb{$selected_features()}.
The callback selects the hyperparameter configuration with the smallest feature set within one standard error of the best performing configuration.
If there are multiple such hyperparameter configurations with the same number of features, the first one is selected.
}
\examples{
clbk("mlr3tuning.one_se_rule")

# Run optimization on the pima data set with the callback
instance = tune(
  tuner = tnr("random_search", batch_size = 15),
  task = tsk("pima"),
  learner = lrn("classif.rpart", cp = to_tune(1e-04, 1e-1, logscale = TRUE)),
  resampling = rsmp("cv", folds = 3),
  measures = msr("classif.ce"),
  term_evals = 30,
  callbacks = clbk("mlr3tuning.one_se_rule")
)

# Hyperparameter configuration with the smallest feature set within one standard error of the best
instance$result
}
