% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskClust.R
\name{autoplot.TaskClust}
\alias{autoplot.TaskClust}
\title{Plots for Clustering Tasks}
\usage{
\method{autoplot}{TaskClust}(object, type = "pairs", theme = theme_minimal(), ...)
}
\arguments{
\item{object}{(\link[mlr3cluster:TaskClust]{mlr3cluster::TaskClust}).}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{theme}{(\code{\link[ggplot2:theme]{ggplot2::theme()}})\cr
The \code{\link[ggplot2:ggtheme]{ggplot2::theme_minimal()}} is applied by default to all plots.}

\item{...}{(ignored).}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
Visualizations for \link[mlr3cluster:TaskClust]{mlr3cluster::TaskClust}.
The argument \code{type} controls what kind of plot is drawn.
Possible choices are:
\itemize{
\item \code{"pairs"} (default): Passes data \code{\link[GGally:ggpairs]{GGally::ggpairs()}}.
}
}
\examples{
if (mlr3misc::require_namespaces("mlr3cluster", quietly = TRUE)) {
library(mlr3cluster)
task = tsk("usarrests")

head(fortify(task))
autoplot(task)
}
}
