% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twostep.R
\name{twostep}
\alias{twostep}
\title{Estimate interaction effects in structural equation models (SEMs) using a twostep procedure}
\usage{
twostep(model.syntax, data, method = "lms", ...)
}
\arguments{
\item{model.syntax}{\code{lavaan} syntax}

\item{data}{dataframe}

\item{method}{method to use:
\describe{
  \item{\code{"dblcent"}}{double centering approach (passed to \code{lavaan}).}
  \item{\code{"ca"}}{constrained approach (passed to \code{lavaan}).}
  \item{\code{"rca"}}{residual centering approach (passed to \code{lavaan}).}
  \item{\code{"uca"}}{unconstrained approach (passed to \code{lavaan}).}
  \item{\code{"pind"}}{prod ind approach, with no constraints or centering (passed to \code{lavaan}).}
  \item{\code{"lms"}}{latent moderated structural equations (not passed to \code{lavaan}).}
  \item{\code{"qml"}}{quasi maximum likelihood estimation (not passed to \code{lavaan}).}
  \item{\code{"custom"}}{use parameters specified in the function call (passed to \code{lavaan}).}
}}

\item{...}{arguments passed to other functions depending on the method (see \code{\link{modsem_pi}} and \code{\link{modsem_da}})}
}
\value{
\code{modsem} object with class \code{\link{modsem_pi}} or \code{\link{modsem_da}}.
}
\description{
Estimate an interaction model using a twostep procedure. For the PI approaches, the \code{lavaan::sam} function
  is used to optimize the models, instead of \code{lavaan::sem}. Note that the product indicators are still used,
  and not the newly developed SAM approach to estimate latent interactions. For the DA approaches (LMS and QML)
  the measurement model is estimated using a CFA (\code{lavaan::cfa}). The structural model is estimated using
  \code{\link{modsem_da}}, where the estimates in the measurement model are fixed, based on the CFA estimates.
  Note that standard errors are uncorrected (i.e., naive), and do not account for the uncertainty in the CFA estimates.
  \strong{NOTE, this is an experimental feature!}
}
\examples{
library(modsem)
m1 <- '
  # Outer Model
  X =~ x1 + x2 +x3
  Y =~ y1 + y2 + y3
  Z =~ z1 + z2 + z3

  # Inner model
  Y ~ X + Z + X:Z
'

est_dblcent <- twostep(m1, oneInt, method = "dblcent")
summary(est_dblcent)

\dontrun{
est_lms <- twostep(m1, oneInt, method = "lms")
summary(est_lms)

est_qml <- twostep(m1, oneInt, method = "qml")
summary(est_qml)
}

tpb_uk <- "
# Outer Model (Based on Hagger et al., 2007)
 ATT =~ att3 + att2 + att1 + att4
 SN =~ sn4 + sn2 + sn3 + sn1
 PBC =~ pbc2 + pbc1 + pbc3 + pbc4
 INT =~ int2 + int1 + int3 + int4
 BEH =~ beh3 + beh2 + beh1 + beh4

# Inner Model (Based on Steinmetz et al., 2011)
 # Causal Relationsships
 INT ~ ATT + SN + PBC
 BEH ~ INT + PBC
 BEH ~ INT:PBC
"

uk_dblcent <- twostep(tpb_uk, TPB_UK, method = "dblcent")
summary(uk_dblcent)

\dontrun{
  uk_qml <- twostep(tpb_uk, TPB_UK, method = "qml")

  uk_lms <- twostep(tpb_uk, TPB_UK, method = "lms", nodes = 32, adaptive.quad = TRUE)
  summary(uk_lms)
}
}
