% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-md.R
\name{show_motherduck_token}
\alias{show_motherduck_token}
\title{Show Your MotherDuck Token}
\usage{
show_motherduck_token(.con)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}
}
\value{
A tibble containing the current MotherDuck token.
}
\description{
Displays the active MotherDuck authentication token associated with the current connection.
Useful for debugging or verifying that your session is authenticated correctly.
}
\details{
The \code{show_motherduck_token()} function executes the internal MotherDuck pragma
\code{print_md_token} and returns the token information. This function should only be
used in secure environments, as it exposes your authentication token in plain text.
It requires a valid MotherDuck connection established with \code{DBI::dbConnect()}.
}
\examples{
\dontrun{
con <- DBI::dbConnect(duckdb::duckdb(dbdir = tempfile()))
show_motherduck_token(con)
DBI::dbDisconnect(con)
}

}
\seealso{
Other db-con: 
\code{\link{install_extensions}()},
\code{\link{load_extensions}()},
\code{\link{validate_extension_install_status}()},
\code{\link{validate_extension_load_status}()}
}
\concept{db-con}
