% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine_ABC.R
\name{engine_ABC}
\alias{engine_ABC}
\title{The Engine of Approximate Bayesian Computation (ABC)}
\usage{
engine_ABC(
  data,
  colnames,
  behrule,
  model,
  funcs = NULL,
  priors,
  settings = NULL,
  control = control,
  ...
)
}
\arguments{
\item{data}{A data frame in which each row represents a single trial,
see \link[multiRL]{data}}

\item{colnames}{Column names in the data frame,
see \link[multiRL]{colnames}}

\item{behrule}{The agent’s implicitly formed internal rule,
see \link[multiRL]{behrule}}

\item{model}{Reinforcement Learning Model}

\item{funcs}{The functions forming the reinforcement learning model,
see \link[multiRL]{funcs}}

\item{priors}{Prior probability density function of the free parameters,
see \link[multiRL]{priors}}

\item{settings}{Other model settings, 
see \link[multiRL]{settings}}

\item{control}{Settings manage various aspects of the iterative process,
see \link[multiRL]{control}}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
A \code{List} containing a \code{DataFrame} of the parameters used to 
   generate the simulated data and the summary statistics for Approximate
   Bayesian Computation (ABC).
}
\description{
Because \code{abc::abc()} requires summary statistics together with the 
   corresponding input parameters, this function converts the generated 
   simulated data into a standardized collection of summary statistics and 
   input parameters, facilitating subsequent execution of \code{abc::abc()}.
}
