% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_stacking.R
\name{df_to_survival_stacked}
\alias{df_to_survival_stacked}
\title{Repeat Observations for Survival Stacking}
\usage{
df_to_survival_stacked(
  data,
  id_col = NULL,
  time_col,
  status_col,
  covariate_cols,
  period_duration = 1,
  custom_times = NULL
)
}
\arguments{
\item{data}{A data frame with survival -type outcomes including an event indicator and a time-to-event-or-censoring column}

\item{id_col}{(string) name of the id column that is unique to each observation in \code{data}. If one is not
specified, one will be created (called \code{.id}) assuming that each row is a unique observation.}

\item{time_col}{(string) name of the time‐to‐event column}

\item{status_col}{(string) name of the 0/1 event indicator column}

\item{covariate_cols}{(string vector) names of your predictors}

\item{period_duration}{(numeric) length of each time-period (e.g. 1)}

\item{custom_times}{(numeric vector) (optional) A vector of the time-period breakpoints. If events could have occurred at any time after zero, this should begin with 0.}
}
\value{
a data.frame of repeated observations, one row for each time-step,
that indicates which observations remain in the risk set and whether or not
an event occurs.
}
\description{
Per the approach in \emph{A review of survival stacking: a method to cast survival regression analysis as a classification problem} \url{https://www.degruyterbrill.com/document/doi/10.1515/ijb-2022-0055/html}
\url{https://arxiv.org/abs/2107.13480}, we provide \code{df_to_survival_stacked} as
a helper function for converting traditional survival data (one observation = one row) into
the survival stacked data structure, a repeated observations data structure where
multiple rows exist for each individual for each timepoint at which they were still in the
risk set up to and including their event time.
}
\examples{
if (requireNamespace("survival", quietly = TRUE)) {
  df_to_survival_stacked(
    data = survival::kidney,
    id_col = 'id',
    time_col = 'time',
    status_col = 'status',
    covariate_cols = c('age', 'sex', 'disease', 'frail'))
}

}
