% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learners.R
\name{lnr_glmnet}
\alias{lnr_glmnet}
\title{glmnet Learner}
\usage{
lnr_glmnet(data, formula, weights = NULL, lambda = 0.2, ...)
}
\arguments{
\item{data}{A dataframe to train a learner / learners on.}

\item{formula}{A regression formula to use inside this learner.}

\item{weights}{Observation weights; see \code{?lm}}

\item{lambda}{The multiplier parameter for the penalty; see \code{?glmnet::glmnet}}

\item{...}{Any extra arguments that should be passed to the internal model
for model fitting purposes.}
}
\value{
A prediction function that accepts \code{newdata},
which returns predictions (a numeric vector of values, one for each row
of \code{newdata}).
}
\description{
A wrapper for \code{glmnet::glmnet()} for use in \code{nadir::super_learner()}.
}
\details{
glmnet predictions will by default, if lambda is unspecified, return a matrix
of predictions for varied lambda values, hence the need to explicitly handle
the lambda argument in building glmnet learners.
}
\examples{
lnr_glmnet(mtcars, mpg ~ hp + disp + am + wt, lambda = .5)(mtcars)
}
\seealso{
learners
}
