% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest.netmeta.R
\name{forest.netmeta}
\alias{forest.netmeta}
\alias{plot.netmeta}
\title{Forest plot for network meta-analysis}
\usage{
\method{forest}{netmeta}(
  x,
  pooled = ifelse(x$random, "random", "common"),
  reference.group = x$reference.group,
  baseline.reference = x$baseline.reference,
  labels = x$trts,
  equal.size = gs("equal.size"),
  leftcols = "studlab",
  leftlabs,
  rightcols = c("effect", "ci"),
  rightlabs,
  digits = gs("digits.forest"),
  small.values = x$small.values,
  nsim = gs("nsim"),
  digits.prop = 2,
  smlab = NULL,
  sortvar = x$seq,
  overall.hetstat = gs("overall.hetstat"),
  print.tau2 = gs("forest.tau2"),
  print.tau = gs("forest.tau"),
  print.I2 = gs("forest.I2"),
  backtransf = x$backtransf,
  lab.NA = gs("lab.NA"),
  add.data,
  addrows.below.overall = if (x$overall.hetstat) 2 else gs("addrows.below.overall"),
  drop.reference.group = gs("drop.reference.group"),
  col.subgroup = "black",
  print.subgroup.name = FALSE,
  ...
)

\method{plot}{netmeta}(x, ...)
}
\arguments{
\item{x}{An object of class \code{netmeta}.}

\item{pooled}{A character string indicating whether results for the
common (\code{"common"}) or random effects model
(\code{"random"}) should be plotted. Can be abbreviated.}

\item{reference.group}{Reference treatment(s).}

\item{baseline.reference}{A logical indicating whether results
should be expressed as comparisons of other treatments versus the
reference treatment (default) or vice versa.}

\item{labels}{An optional vector with treatment labels.}

\item{equal.size}{A logical indicating whether all squares should
be of equal size. Otherwise, the square size is proportional to
the precision of estimates.}

\item{leftcols}{A character vector specifying columns to be plotted
on the left side of the forest plot or a logical value (see
Details).}

\item{leftlabs}{A character vector specifying labels for
(additional) columns on left side of the forest plot (see
Details).}

\item{rightcols}{A character vector specifying columns to be
plotted on the right side of the forest plot or a logical value
(see Details).}

\item{rightlabs}{A character vector specifying labels for
(additional) columns on right side of the forest plot (see
Details).}

\item{digits}{Minimal number of significant digits for treatment
effects and confidence intervals, see \code{print.default}.}

\item{small.values}{A character string specifying whether small
treatment effects indicate a beneficial (\code{"desirable"}) or
harmful (\code{"undesirable"}) effect, can be abbreviated; see
\code{\link{netrank}}.}

\item{nsim}{Number of repetitions to calculate SUCRAs.}

\item{digits.prop}{Minimal number of significant digits for
P-scores, SUCRAs and direct evidence proportions, see
\code{\link{print.default}} and \code{\link{netrank}}.}

\item{smlab}{A label printed at top of figure. By default, text
indicating either common or random effects model is printed.}

\item{sortvar}{An optional vector used to sort treatments (must be
of same length as the total number of treatments).}

\item{overall.hetstat}{A logical indicating whether to print heterogeneity
measures.}

\item{print.tau2}{A logical value indicating whether to print the
value of the between-study variance \eqn{\tau^2}.}

\item{print.tau}{A logical value indicating whether to print
\eqn{\tau}, the square root of the between-study variance
\eqn{\tau^2}.}

\item{print.I2}{A logical value indicating whether to print the
value of the I-squared statistic.}

\item{backtransf}{A logical indicating whether results should be
back transformed in forest plots. If \code{backtransf = TRUE},
results for \code{sm = "OR"} are presented as odds ratios rather
than log odds ratios, for example.}

\item{lab.NA}{A character string to label missing values.}

\item{add.data}{An optional data frame with additional columns to
print in forest plot (see Details).}

\item{addrows.below.overall}{A numeric value indicating how many
empty rows are printed between meta-analysis results and
heterogeneity statistics.}

\item{drop.reference.group}{A logical indicating whether the
reference group should be printed in the forest plot.}

\item{col.subgroup}{The colour to print information on subgroups.}

\item{print.subgroup.name}{A logical indicating whether the name of
the grouping variable should be printed in front of the group
labels.}

\item{\dots}{Additional arguments for \code{\link[meta]{forest.meta}}
function.}
}
\description{
Draws a forest plot in the active graphics window (using grid
graphics system).
}
\details{
A forest plot, also called confidence interval plot, is drawn in
the active graphics window.

Argument \code{sortvar} can be either a numeric or character vector
with length of number of treatments. If \code{sortvar} is numeric
the \code{\link[base]{order}} function is utilised internally to
determine the order of values. If \code{sortvar} is character it
must be a permutation of the treatment names. It is also possible
to provide either \code{sortvar = Pscore}, \code{sortvar =
"Pscore"}, \code{sortvar = -Pscore}, or \code{sortvar = "-Pscore"}
in order to sort treatments according to the ranking generated by
\code{\link{netrank}} which is called internally. It is also
possible to use "SUCRA" instead of "Pscore". Similar expressions
are possible to sort by treatment comparisons (\code{sortvar = TE},
etc.), standard error (\code{sortvar = seTE}), number of studies
with direct treatment comparisons (\code{sortvar = k}), and direct
evidence proportion (\code{sortvar = prop.direct}, see also
\code{\link{netmeasures}}).

The arguments \code{leftcols} and \code{rightcols} can be used to
specify columns which are plotted on the left and right side of the
forest plot, respectively. The following columns are available:
\tabular{ll}{
\bold{Name} \tab \bold{Definition} \cr
\code{"studlab"} \tab Treatments \cr
\code{"TE"} \tab Network estimates (either from common or random
  effects model) \cr
\code{"seTE"} \tab Corresponding standard errors \cr
\code{"Pscore"} \tab P-scores (see \code{\link{netrank}}) \cr
\code{"SUCRA"} \tab SUCRAs (see \code{\link{netrank}}) \cr
\code{"n.trts"} \tab Number of participants per treatment arm \cr
\code{"k"} \tab Number of studies in pairwise comparisons \cr
\code{"prop.direct"} \tab Direct evidence proportions (see
  \code{\link{netmeasures}}) \cr
\code{"effect"} \tab (Back-transformed) network estimates \cr
\code{"ci"} \tab Confidence intervals \cr
\code{"effect.ci"} \tab (Back-transformed) network estimates and
  confidence intervals
}

As a sidenote, the rather odd column name \code{"studlab"} to
describe the treatment comparisons comes from internally calling
\code{\link[meta]{forest.meta}} which uses study labels as the essential
information.

Argument \code{add.data} can be used to add additional columns to
the forest plot. This argument must be a data frame with row names
equal to the treatment names in R object \code{x}, i.e.,
\code{x$trts}.

See help page of \code{\link[meta]{forest.meta}} for more information on
the generation of forest plots and additional arguments.
}
\examples{
# Examples: example(netmeta)

}
\seealso{
\code{\link[meta]{forest.meta}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
\keyword{hplot}
