% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_class.R, R/mapped_neurovec.R
\docType{class}
\name{MappedNeuroVec-class}
\alias{MappedNeuroVec-class}
\alias{MappedNeuroVec}
\title{MappedNeuroVec Class}
\usage{
MappedNeuroVec(file_name, label = basename(file_name))
}
\arguments{
\item{file_name}{Character string specifying the path to the neuroimaging file.
Supported formats include NIFTI (.nii) and ANALYZE (.hdr/.img).}

\item{label}{Optional character string providing a label for the vector}
}
\value{
A new \code{\linkS4class{MappedNeuroVec}} object providing:
\itemize{
  \item Memory-mapped access to the data
  \item Spatial and temporal indexing
  \item Efficient data extraction
  \item Automatic memory management
}
}
\description{
A class representing a four-dimensional brain image backed by a memory-mapped file.
This class provides efficient access to large brain images without loading the
entire dataset into memory.

The \code{MappedNeuroVec} class provides memory-efficient access to large neuroimaging
datasets through memory mapping. This allows processing of datasets larger than available
RAM by keeping data on disk and only loading requested portions into memory.

Creates a \code{\linkS4class{MappedNeuroVec}} object that provides efficient,
memory-mapped access to large neuroimaging datasets. This allows processing of
data larger than available RAM by keeping it on disk and only loading requested
portions into memory.
}
\details{
MappedNeuroVec objects use memory-mapped files to store and access large 4D brain
images efficiently. This approach allows for rapid access to specific portions of
the data without requiring the entire dataset to be loaded into memory at once.

Create a Memory-Mapped Neuroimaging Vector


The function implements several key features:
\itemize{
  \item Zero-copy access to file data
  \item Automatic memory management
  \item Support for large datasets
  \item Efficient random access
  \item Proper cleanup on object deletion
}

Memory mapping is particularly useful when:
\itemize{
  \item Working with large datasets
  \item Only portions of data are needed at once
  \item Random access is required
  \item Multiple processes need to share data
}
}
\section{Slots}{

\describe{
\item{\code{filemap}}{An object of class \code{mmap} representing the memory-mapped file
containing the brain image data.}

\item{\code{offset}}{An integer representing the byte offset within the memory-mapped file
where the brain image data starts.}
}}

\section{Methods}{

This class inherits methods from \code{\linkS4class{NeuroVec}} and implements
the \code{ArrayLike4D} interface. Additional methods specific to memory-mapped
operations may be available.
}

\section{Implementation Details}{

The class uses the \code{mmap} package to establish a memory mapping between the file
and memory space. Key features include:
\itemize{
  \item Zero-copy access to file data
  \item Automatic memory management
  \item Support for large datasets
  \item Efficient random access
}
}

\examples{

# Create a MappedNeuroVec object (pseudo-code)
file_path <- system.file("extdata", "global_mask_v4.nii", package = "neuroim2")
mapped_vec <- MappedNeuroVec(file_path)

# Access a subset of the data
subset <- mapped_vec[,,, 1:2]


# Create mapped vector from NIFTI file
mvec <- MappedNeuroVec(system.file("extdata", "global_mask_v4.nii", package = "neuroim2"))

# Extract first volume
vol1 <- mvec[[1]]

# Get dimensions
dim(mvec)

# Access specific timepoint
timepoint <- mvec[, , , 2]


}
\seealso{
\code{\link{NeuroVec-class}} for the parent class.
\code{\link[mmap]{mmap}} for details on memory-mapped file objects.

\code{\link{MappedNeuroVec}} for creating instances of this class

\code{\link[mmap]{mmap}} for memory mapping details
}
