% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image-utils.R
\name{fsmorph_to_gifti}
\alias{fsmorph_to_gifti}
\title{Convert FreeSurfer morphometry to GIFTI}
\usage{
fsmorph_to_gifti(morph_path, output_path = NULL)
}
\arguments{
\item{morph_path}{Path to FreeSurfer morphometry file.}

\item{output_path}{Output GIFTI path. If \code{NULL}, replaces the extension
with \code{.func.gii}.}
}
\value{
The output file path (invisibly).
}
\description{
Reads a FreeSurfer morphometry file (\code{.curv}, \code{.thickness}, \code{.sulc}) and
writes a GIFTI func file.
}
\examples{
\dontrun{
fsmorph_to_gifti("lh.thickness")
fsmorph_to_gifti("lh.thickness", "lh.thickness.func.gii")
}
}
\references{
Markello RD et al. (2022) Nature Methods 19:1472-1480.
doi:10.1038/s41592-022-01625-w
}
