% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nulls-alexander-bloch.R
\name{null_alexander_bloch}
\alias{null_alexander_bloch}
\title{Alexander-Bloch spin test null model}
\usage{
null_alexander_bloch(
  data,
  coords,
  n_perm = 1000L,
  seed = NULL,
  rotation = c("euler", "rodrigues")
)
}
\arguments{
\item{data}{Numeric vector of brain map values.}

\item{coords}{List with \verb{$lh} and \verb{$rh} matrices of spherical coordinates
(n x 3 each).}

\item{n_perm}{Integer number of null permutations to generate.}

\item{seed}{Optional integer seed for reproducibility.}

\item{rotation}{Rotation generation method: \code{"euler"} (ZYZ Euler angles,
default, matches neuromaps Python) or \code{"rodrigues"} (Rodrigues axis-angle
formula).}
}
\value{
A \link{null_distribution} object.
}
\description{
Original vertex-level spin test: rotates coordinates and assigns each rotated
vertex the value of its nearest original vertex (no optimal matching).
}
\examples{
coords <- list(lh = matrix(rnorm(30), 10, 3), rh = matrix(rnorm(30), 10, 3))
data <- rnorm(20)
nd <- null_alexander_bloch(data, coords, n_perm = 10L, seed = 1L)
}
\references{
Alexander-Bloch AF et al. (2018) NeuroImage 175:111-120.
doi:10.1016/j.neuroimage.2018.04.023
}
