% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nulls-baum.R
\name{null_baum}
\alias{null_baum}
\title{Baum spin test null model}
\usage{
null_baum(
  data,
  coords,
  parcellation,
  n_perm = 1000L,
  seed = NULL,
  rotation = c("euler", "rodrigues")
)
}
\arguments{
\item{data}{Numeric vector of brain map values.}

\item{coords}{List with \verb{$lh} and \verb{$rh} matrices of spherical coordinates
(n x 3 each).}

\item{parcellation}{Integer vector of parcel labels for all vertices.
\code{0} and \code{NA} indicate medial wall.}

\item{n_perm}{Integer number of null permutations to generate.}

\item{seed}{Optional integer seed for reproducibility.}

\item{rotation}{Rotation generation method: \code{"euler"} (ZYZ Euler angles,
default, matches neuromaps Python) or \code{"rodrigues"} (Rodrigues axis-angle
formula).}
}
\value{
A \link{null_distribution} object.
}
\description{
Spin-based null model with maximum-overlap parcel reassignment. After
rotating vertex coordinates, each original parcel is assigned the value
of the rotated parcel with the most vertex overlap.
}
\examples{
coords <- list(lh = matrix(rnorm(30), 10, 3), rh = matrix(rnorm(30), 10, 3))
parcellation <- c(rep(1L, 5), rep(2L, 5), rep(3L, 5), rep(4L, 5))
data <- c(1.0, 2.0, 3.0, 4.0)
nd <- null_baum(data, coords, parcellation, n_perm = 10L, seed = 1L)
}
\references{
Baum GL et al. (2020) PNAS 117:21854-21861.
doi:10.1073/pnas.2005518117
}
