% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nulls-burt2018.R
\name{null_burt2018}
\alias{null_burt2018}
\title{Burt 2018 spatial autoregressive null model}
\usage{
null_burt2018(data, distmat, n_perm = 1000L, seed = NULL)
}
\arguments{
\item{data}{Numeric vector of brain map values.}

\item{distmat}{Distance matrix between parcels/vertices.}

\item{n_perm}{Integer number of null permutations to generate.}

\item{seed}{Optional integer seed for reproducibility.}
}
\value{
A \link{null_distribution} object.
}
\description{
Generates surrogate brain maps using a spatial autoregressive (SAR) model.
Estimates spatial autocorrelation and distance decay parameters, then
generates surrogates by solving the SAR equation and rank-matching to the
original data.
}
\examples{
data <- rnorm(50)
distmat <- as.matrix(dist(matrix(rnorm(100), 50, 2)))
nd <- null_burt2018(data, distmat, n_perm = 10L, seed = 1L)
}
\references{
Burt JB et al. (2018) Nature Neuroscience 21:1251-1259.
doi:10.1038/s41593-018-0195-0
}
