% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nulls-variogram.R
\name{null_burt2020}
\alias{null_burt2020}
\title{Variogram-matching null model}
\usage{
null_burt2020(
  data,
  distmat,
  n_perm = 1000L,
  seed = NULL,
  ns = 500L,
  nh = 25L,
  pv = 25,
  knn = 1000L,
  deltas = seq(0.1, 0.9, by = 0.1),
  kernel = c("exponential", "gaussian", "uniform"),
  resample = FALSE
)
}
\arguments{
\item{data}{Numeric vector of brain map values.}

\item{distmat}{Distance matrix between parcels/vertices.}

\item{n_perm}{Integer number of null permutations to generate.}

\item{seed}{Optional integer seed for reproducibility.}

\item{ns}{Integer, subsample size for variogram computation.}

\item{nh}{Integer, number of distance bins for variogram.}

\item{pv}{Numeric, percentile cutoff for maximum distance in variogram.}

\item{knn}{Integer, number of nearest neighbors for smoothing.}

\item{deltas}{Numeric vector of smoothing levels (fractions of \code{knn}).}

\item{kernel}{Smoothing kernel function.}

\item{resample}{Logical. If \code{FALSE} (default, matches brainsmash Python),
variogram subsample indices are computed once and reused across all
permutations. If \code{TRUE}, a fresh subsample is drawn each time.}
}
\value{
A \link{null_distribution} object.
}
\description{
Generates spatially-constrained surrogate brain maps by matching the
empirical variogram of the original data through smoothed random
permutations.
}
\examples{
data <- rnorm(50)
distmat <- as.matrix(dist(matrix(rnorm(100), 50, 2)))
nd <- null_burt2020(data, distmat, n_perm = 10L, seed = 1L)
}
\references{
Burt JB et al. (2020) NeuroImage 220:117038.
doi:10.1016/j.neuroimage.2020.117038
}
