% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image-utils.R
\name{vertex_areas}
\alias{vertex_areas}
\title{Compute per-vertex surface areas}
\usage{
vertex_areas(vertices, faces)
}
\arguments{
\item{vertices}{Numeric matrix (n x 3) of vertex coordinates.}

\item{faces}{Integer matrix (m x 3) of face indices (1-indexed).}
}
\value{
Numeric vector of length \code{nrow(vertices)}.
}
\description{
Each triangle distributes one-third of its area to each of its three
vertices. Triangle area is computed via the cross-product formula.
}
\examples{
vertices <- matrix(c(0, 1, 0, 0, 0, 1, 0, 0, 0), nrow = 3, byrow = TRUE)
faces <- matrix(c(1L, 2L, 3L), nrow = 1)
vertex_areas(vertices, faces)
}
