% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{read_nhanes}
\alias{read_nhanes}
\title{Read NHANES Data from Cloud Storage}
\usage{
read_nhanes(dataset)
}
\arguments{
\item{dataset}{Character. NHANES dataset base name (e.g., "trigly", "demo").
\strong{Case-insensitive} - use 'demo', 'DEMO', or 'Demo' interchangeably.
Must be a single string (length 1). Leading/trailing whitespace is
automatically trimmed.}
}
\value{
A tibble containing the requested NHANES dataset across all
available survey cycles. Always includes \code{year} and \code{seqn}
columns plus dataset-specific variables.
}
\description{
Downloads pre-processed NHANES data files from cloud storage. Data includes
all survey cycles (1999-2023) automatically merged and harmonized, with
quarterly updates.
}
\details{
This function downloads NHANES datasets from cloud storage (hosted at
nhanes.kylegrealis.com). All datasets combine multiple survey cycles with
automatic type harmonization. Data is updated quarterly via automated
workflows that pull fresh data from CDC servers.

\strong{Dataset names are case-insensitive throughout this package.} Use uppercase
(matches CDC documentation) or lowercase (easier to type) - both work identically.

\strong{Error handling:} The function validates inputs and provides informative
error messages if the dataset fails to load (e.g., network issues, non-existent
datasets, misspelled names). Error messages include the attempted URL and
suggestions for troubleshooting.
}
\examples{
\donttest{
# All case variations work identically:
trigly <- read_nhanes("trigly") # Lowercase
demo <- read_nhanes("DEMO") # Uppercase
acq <- read_nhanes("Acq") # Mixed case
}

}
