% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Playoff.R
\name{series_schedule}
\alias{series_schedule}
\title{Access the playoff schedule for a season and series}
\usage{
series_schedule(season = season_now() - 10001, series = "a")
}
\arguments{
\item{season}{integer in YYYYYYYY (e.g., 20242025); see \code{\link[=seasons]{seasons()}} for
reference}

\item{series}{one-letter code (e.g., 'O'); see \code{\link[=series]{series()}} and/or
\code{\link[=bracket]{bracket()}} for reference}
}
\value{
data.frame with one row per game
}
\description{
\code{series_schedule()} retrieves the playoff schedule for a season and series as a \code{data.frame} where each row represents game and includes detail on game timeline state, period/clock progression, and matchup flow, date/season filtering windows and chronological context, and team identity, affiliation, and matchup-side context.
}
\examples{
SCF_schedule_20212022 <- series_schedule(
  season = 20212022, 
  series = 'O'
)
}
