% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_tlc_new_driver_app_status.R
\name{nyc_tlc_new_driver_app_status}
\alias{nyc_tlc_new_driver_app_status}
\title{NYC TLC New Driver Application Status}
\source{
NYC Open Data: <https://data.cityofnewyork.us/resource/dpec-ucu7>
}
\usage{
nyc_tlc_new_driver_app_status(
  limit = 10000,
  filters = list(),
  timeout_sec = 30
)
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}

\item{timeout_sec}{Request timeout in seconds (default = 30).}
}
\value{
A tibble containing TLC New Driver Application Status data.
}
\description{
Downloads TLC New Driver Application Status data from NYC Open Data.
}
\details{
This dataset provides the application status for individuals applying
for a New York City Taxi and Limousine Commission (TLC) driver's license.
It includes details such as application date, drug test status,
defensive driving completion, and final approval outcome.
}
\examples{
# Examples that hit the live NYC Open Data API are guarded so CRAN checks
# do not fail when the network is unavailable or slow.
if (interactive() && curl::has_internet()) {
  # Quick example (fetch 2 rows)
  small_sample <- nyc_tlc_new_driver_app_status(limit = 2)
  small_sample

  nyc_tlc_new_driver_app_status(limit = 2, filters = list(drug_test = "NEEDED"))
}
}
