% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od.2m.111.R
\name{od.2m.111}
\alias{od.2m.111}
\title{Optimal sample allocation calculation for two-level multisite-randomized
    trials investigating mediation effects with individual-level mediators
    (1-1-1)}
\usage{
od.2m.111(
  a = NULL,
  b = NULL,
  icc.m = NULL,
  icc = NULL,
  c1 = NULL,
  c1t = NULL,
  c2 = NULL,
  m = NULL,
  r12m = 0,
  r22m = 0,
  r12 = 0,
  omega = 0.01,
  q.a = 0,
  q.b = 3,
  test = "joint",
  n = NULL,
  p = NULL,
  iter = 100,
  tol = 1e-11,
  power = 0.8,
  d.p = c(0.1, 0.5),
  d.n = c(5, 50),
  sig.level = 0.05,
  two.tailed = TRUE,
  plots = TRUE,
  nlim = c(4, 100),
  plim = c(0.01, 0.99),
  varlim = c(0, 0.001),
  nlab = NULL,
  plab = NULL,
  varlab = NULL,
  vartitle = NULL,
  Jlim = c(3, 1e+05),
  verbose = TRUE,
  max.value = Inf,
  max.iter = 300,
  e = 1e-10,
  n.of.ants = 10,
  n.of.archive = 50,
  q = 1e-04,
  xi = 0.5,
  plot.by = list(n = "n", p = "p")
)
}
\arguments{
\item{a}{The treatment effect on the mediator.}

\item{b}{The within treatment correlation between the outcome and the mediator.}

\item{icc.m}{The intraclass correlation coefficient for the mediator.}

\item{icc}{The unconditional intraclass correlation coefficient (ICC) in population or in
each treatment condition.}

\item{c1}{The cost of sampling one level-1 unit in control condition.}

\item{c1t}{The cost of sampling one level-1 unit in treatment condition.}

\item{c2}{The cost of sampling one level-2 unit (site).}

\item{m}{Total budget.}

\item{r12m}{The proportion of within treatment mediator variance at the level one
explained by covariates.}

\item{r22m}{The proportion of treatment-by-site variance 
explained by covariates.}

\item{r12}{The proportion of within treatment individual-level outcome variance
explained by covariates.}

\item{omega}{The treatment-by-site variance of the outcome.}

\item{q.a}{The number of covariates at the individual level of the mediator model
(except the treatment indicator).}

\item{q.b}{The number of covariates in the outcome model (except the treatment indicator
and the mediator).}

\item{test}{The type of test will be used to detect mediation effects. Default is
the joint significance test (i.e., test = "joint").
Another choice is the Sobel test by specifying the argument as test = "sobel".}

\item{n}{The level-1 sample size per level-2 unit.}

\item{p}{The proportion of level-1 units to be assigned to treatment.}

\item{iter}{number of iteration used for solving roots in the Sobel test.}

\item{tol}{convergence tolerance.}

\item{power}{Statistical power specified, default is .80.}

\item{d.p}{The initial sampling domains for p. Default is c(0.10, 0.50).}

\item{d.n}{The initial sampling domain for n. Default is c(4, 500).}

\item{sig.level}{Significance level or type I error rate, default value is 0.05.}

\item{two.tailed}{Logical; two-tailed tests if TRUE,
otherwise one-tailed tests; default value is TRUE.}

\item{plots}{Logical, provide variance plots if TRUE, otherwise not; default value is TRUE.}

\item{nlim}{The plot range for n, default value is c(2, 50).}

\item{plim}{The plot range for p, default value is c(0, 1).}

\item{varlim}{The plot range for variance, default value is c(0, 0.05).}

\item{nlab}{The plot label for \code{n},
default value is "Level-1 Sample Size: n".}

\item{plab}{The plot label for \code{p},
default value is "Proportion Level-3 Units in Treatment: p".}

\item{varlab}{The plot label for variance,
default value is "Variance".}

\item{vartitle}{The title of variance plot, default value is NULL.}

\item{Jlim}{The range for J to search for a numerical solution. Default is c(3, 10e4).}

\item{verbose}{Print out evaluation process if TRUE, default is TRUE.}

\item{max.value}{Maximal value of optimization when used as
the stopping criterion. Default is infinite.}

\item{max.iter}{Maximal number of function evaluations when used as
the stopping criterion. Default is 200.}

\item{e}{Maximum error value used when solution quality used as
the stopping criterion, default is 1e-10.}

\item{n.of.ants}{Number of ants used in each iteration after the initialization
of power analysis for calculating required budget, default value is 10.}

\item{n.of.archive}{Size of the solution archive, default is 100.}

\item{q}{Locality of the search (0,1), default is 0.0001.}

\item{xi}{Convergence pressure (0, Inf), suggested: (0, 1), default is 0.5.}

\item{plot.by}{Plot the variance by \code{n}, \code{J}, \code{K} and/or \code{p};
default value is plot.by = list(n = "n", J = "J", K = 'K', p = "p").}
}
\value{
Unconstrained or constrained optimal sample allocation (\code{n} and \code{p}).
    The function also returns statistical power,
    function name, design type,
    and parameters used in the calculation.
}
\description{
The optimal design of two-level
    multisite-randomized trials (MRTs) probing mediation effects with
    individual-level mediators, for the
    Sobel test, is to calculate
    the optimal sample allocation that minimizes the variance of
    a mediation effect under a fixed budget. For the joint significance test, it is to identify
    the optimal sample allocation that requires the minimum budget
    to achieve certain power level.
    The optimal design parameters include
    the level-1 sample size per level-2 unit (\code{n})
    and the proportion of level-1 individuals/units to be assigned to treatment (\code{p}).
    This function solves the optimal \code{n} and/or \code{p}
    with and without a constraint.
}
