% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pptx_informations.R
\name{layout_properties}
\alias{layout_properties}
\title{Slide layout properties}
\usage{
layout_properties(x, layout = NULL, master = NULL)
}
\arguments{
\item{x}{an \code{rpptx} object}

\item{layout}{slide layout name. If \code{NULL}, returns all layouts.}

\item{master}{master layout name where \code{layout} is located. If \code{NULL}, returns all masters.}
}
\value{
Returns a data frame with one row per placeholder and the following columns:
\itemize{
\item \code{master_name}: Name of master (a \code{.pptx} file may have more than one)
\item \code{name}: Name of layout
\item \code{type}: Placeholder type
\item \code{type_idx}: Running index for phs of the same type. Ordering by ph position
(top -> bottom, left -> right)
\item \code{id}: A unique placeholder id (assigned by PowerPoint automatically, starts at 2, potentially non-consecutive)
\item \code{ph_label}: Placeholder label (can be set by the user in PowerPoint)
\item \code{ph}: Placholder XML fragment (usually not needed)
\item \code{offx},\code{offy}: placeholder's distance from left and top edge (in inch)
\item \code{cx},\code{cy}: width and height of placeholder (in inch)
\item \code{rotation}: rotation in degrees
\item \code{fld_id} is generally stored as a hexadecimal or GUID value
\item \code{fld_type}: a unique identifier for a particular field
}
}
\description{
Detailed information about the placeholders on the slide layouts (label, position, etc.).
See \emph{Value} section below for more info.
}
\examples{
library(officer)

x <- read_pptx()
layout_properties(x = x, layout = "Title Slide", master = "Office Theme")
layout_properties(x = x, master = "Office Theme")
layout_properties(x = x, layout = "Two Content")
layout_properties(x = x)
}
\seealso{
Other functions for reading presentation information: 
\code{\link{annotate_base}()},
\code{\link{color_scheme}()},
\code{\link{doc_properties}()},
\code{\link{layout_summary}()},
\code{\link{length.rpptx}()},
\code{\link{plot_layout_properties}()},
\code{\link{slide_size}()},
\code{\link{slide_summary}()}
}
\concept{functions for reading presentation information}
