% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_qtrap.R
\name{convert_mrm_data}
\alias{convert_mrm_data}
\title{Convert MRM Data to Wide Format}
\usage{
convert_mrm_data(
  data,
  response_col,
  sample_name_col = "data_filename",
  sample_id_col = "sample_id",
  component_name_col = "component_name"
)
}
\arguments{
\item{data}{A tibble containing the MRM transition data.}

\item{response_col}{Name of the column containing the response data to be spread.}

\item{sample_name_col}{Name of the column containing sample name information.}

\item{sample_id_col}{Name of the column containing sample ID information.}

\item{component_name_col}{Name of the column containing component name information.}
}
\value{
A tibble in wide format with samples as rows and compounds as columns.
}
\description{
This function converts a tibble containing MRM data to a wide format based on the specified response column.
}
\examples{
\dontrun{
all_txt <- tibble::tribble(
  ~`data_filename`, ~`sample_id`, ~`component_name`, ~Area, ~`IS Area`,
  "Sample1", "ID1", "Compound1", 100, 50,
  "Sample1", "ID2", "Compound2", 200, 75,
  "Sample2", "ID1", "Compound1", 150, 60,
  "Sample2", "ID2", "Compound2", 250, 80
)
area_data <- convert_mrm_data(all_txt, "Area", "data_filename", "sample_id", "component_name")
is_area_data <- convert_mrm_data(all_txt, "IS Area", "data_filename", "sample_id", "component_name")
print(area_data)
print(is_area_data)
}
}
\author{
Yaoxiang Li
}
