% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_chartsheet}
\alias{wb_add_chartsheet}
\title{Add a chartsheet to a workbook}
\usage{
wb_add_chartsheet(
  wb,
  sheet = next_sheet(),
  tab_color = NULL,
  zoom = 100,
  visible = c("true", "false", "hidden", "visible", "veryhidden"),
  ...
)
}
\arguments{
\item{wb}{A \link{wbWorkbook} object to which the new chartsheet will be attached.}

\item{sheet}{A character string for the chartsheet name. Defaults to a
sequentially generated name (e.g., "Sheet 1").}

\item{tab_color}{The color of the sheet tab. Accepts a \code{\link[=wb_color]{wb_color()}} object,
a standard R color name, or a hex color code.}

\item{zoom}{The zoom level as a percentage; a numeric value between 10 and 400.}

\item{visible}{The visibility state of the sheet. Options include "visible",
"hidden", or "veryHidden".}

\item{...}{Additional arguments passed to internal configuration methods.}
}
\description{
The \code{wb_add_chartsheet()} function appends a specialized chartsheet to a
\code{wbWorkbook} object. Unlike standard worksheets, which contain a grid of cells,
a chartsheet is dedicated exclusively to the display of a single, full-page
chart.
}
\details{
A chartsheet is a distinct sheet type in the OpenXML specification. It
does not support standard cell data, grid lines, or typical worksheet
features. Its primary purpose is to provide a high-level, focused view of a
graphical representation.

\strong{Important:} A chartsheet must contain a chart object to be
valid. Adding a chartsheet without subsequently attaching a chart via
\code{\link[=wb_add_mschart]{wb_add_mschart()}} will result in a corrupt workbook
that may fail to open in spreadsheet software.

Like standard worksheets, chartsheets support visual customization such as
\code{tab_color}, \code{zoom} levels, and various \code{visible} states.
}
\seealso{
\code{\link[=wb_add_mschart]{wb_add_mschart()}}, \code{\link[=wb_add_worksheet]{wb_add_worksheet()}}

Other workbook wrappers: 
\code{\link{base_font-wb}},
\code{\link{col_widths-wb}},
\code{\link{creators-wb}},
\code{\link{grouping-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_data}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_hyperlink}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_slicer}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_base_colors}},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_copy_cells}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()},
\code{\link{wb_save}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_workbook}()}
}
\concept{workbook wrappers}
