% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validator.R
\name{v_numeric_scalar}
\alias{v_numeric_scalar}
\title{Validator for Numeric Scalar Values}
\usage{
v_numeric_scalar()
}
\value{
A validator function that takes a value \code{x} and raises an error
if \code{x} is not a single numeric value.
}
\description{
\code{v_numeric_scalar()} returns a validator function that checks if a value
is a single numeric value. This is useful as a validator function for
options managers created with \code{\link[=create_options_manager]{create_options_manager()}}.
}
\examples{
# Create a validator for numeric scalars
validator <- v_numeric_scalar()

# Valid input
validator(42)

# Invalid inputs (would raise errors)
try(validator(c(1, 2, 3))) # vector, not scalar
try(validator("text")) # not numeric
}
