% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validator.R
\name{v_numeric_vector}
\alias{v_numeric_vector}
\title{Validator for Numeric Vectors}
\usage{
v_numeric_vector(min_len = 1, finite = TRUE)
}
\arguments{
\item{min_len}{Minimum length required for the vector. Defaults to 1.}

\item{finite}{If TRUE (default), rejects non-finite values (Inf, -Inf, NaN).
If FALSE, non-finite values are allowed.}
}
\value{
A validator function that takes a value \code{x} and raises an error if:
\itemize{
\item \code{x} is not numeric
\item \code{x} has fewer than \code{min_len} elements
\item \code{x} contains NA values
\item \code{finite} is TRUE and \code{x} contains non-finite values
}
}
\description{
\code{v_numeric_vector()} returns a validator function that checks if a value
is a numeric vector meeting specified length and finiteness requirements.
This is useful for options requiring numeric sequences or datasets.
}
\examples{
# Create a validator for numeric vectors of at least length 3
validator <- v_numeric_vector(min_len = 3)

# Valid input
validator(c(1, 2, 3))
validator(c(0.5, 1.5, 2.5, 3.5))

# Invalid inputs (would raise errors)
try(validator(c(1, 2)))  # too short
try(validator(c(1, NA, 3)))  # contains NA
try(validator(c(1, Inf, 3)))  # contains non-finite value
try(validator("not numeric"))  # not numeric
}
