% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outpack_helpers.R
\name{orderly_copy_files}
\alias{orderly_copy_files}
\title{Copy files from a packet}
\usage{
orderly_copy_files(
  expr,
  files,
  dest,
  overwrite = TRUE,
  name = NULL,
  location = NULL,
  allow_remote = NULL,
  fetch_metadata = FALSE,
  parameters = NULL,
  options = NULL,
  envir = parent.frame(),
  root = NULL
)
}
\arguments{
\item{expr}{The query expression. A \code{NULL} expression matches everything.}

\item{files}{Files to copy from the other packet, as a character vector.
If the character vector is unnamed, the files listed are copied over
without changing their names. If the vector is named however, the names
will be used as the destination name for the files.

In either case, if you want to import a directory of files from a
packet, you must refer to the source with a trailing slash
(e.g., \code{c(here = "there/")}), which will create the local
directory \code{here/...} with files from the upstream packet
directory \verb{there/}. If you omit the slash then an error will be
thrown suggesting that you add a slash if this is what you
intended.

You can use a limited form of string interpolation in the names of
this argument; using \verb{$\{variable\}} will pick up values from
\code{envir} and substitute them into your string.  This is similar
to the interpolation you might be familiar with from
\code{glue::glue} or similar, but much simpler with no concatenation
or other fancy features supported.

Note that there is an unfortunate, but (to us) avoidable
inconsistency here; interpolation of values from your
environment in the query is done by using \code{environment:x} and in
the destination filename by doing \verb{$\{x\}}.

If you want to copy \emph{all} files from the packet, use \verb{./} (read
this as the directory of the packet).  The trailing slash is
required in order to be consistent with the rules above.}

\item{dest}{The directory to copy into}

\item{overwrite}{Overwrite files at the destination; this is
typically what you want, but set to \code{FALSE} if you would prefer
that an error be thrown if the destination file already exists.}

\item{name}{Optionally, the name of the packet to scope the query on. This
will be intersected with \code{scope} arg and is a shorthand way of running
\code{scope = list(name = "name")}}

\item{location}{Optional vector of locations to pull from. We
might in future expand this to allow wildcards or exceptions.}

\item{allow_remote}{Logical, indicating if we should allow packets
to be found that are not currently unpacked (i.e., are known
only to a location that we have metadata from). If this is
\code{TRUE}, then in conjunction with \code{\link[=orderly_dependency]{orderly_dependency()}}
you might pull a large quantity of data.  The default is \code{NULL}. This is
\code{TRUE} if remote locations are listed explicitly as a character
vector in the \code{location} argument, or if you have specified
\code{fetch_metadata = TRUE}, otherwise \code{FALSE}.}

\item{fetch_metadata}{Logical, indicating if we should pull
metadata immediately before the search. If \code{location} is given,
then we will pass this through to
\code{\link[=orderly_location_fetch_metadata]{orderly_location_fetch_metadata()}} to filter locations
to update.  If pulling many packets in sequence, you \emph{will} want
to update this option to \code{FALSE} after the first pull, otherwise
it will update the metadata between every packet, which will be
needlessly slow.}

\item{parameters}{Optionally, a named list of parameters to substitute
into the query (using the \verb{this:} prefix)}

\item{options}{\strong{DEPRECATED}. Please don't use this any more, and
instead use the arguments \code{location}, \code{allow_remote} and
\code{fetch_metadata} directly.}

\item{envir}{Optionally, an environment to substitute into the
query (using the \verb{environment:} prefix). The default here is to
use the calling environment, but you can explicitly pass this in
if you want to control where this lookup happens.}

\item{root}{The path to the root directory, or \code{NULL} (the
default) to search for one from the current working
directory. This function does not require that the directory is
configured for orderly, and can be any \code{outpack} root (see
\code{\link[=orderly_init]{orderly_init()}} for details).}
}
\value{
Primarily called for its side effect of copying files from
a packet into the directory \code{dest}.  Also returns a list with
information about the copy, containing elements:
\itemize{
\item \code{id}: The resolved id of the packet
\item \code{name}: The name of the packet
\item \code{files}: a \link{data.frame} of filenames with columns \code{here}
(the name of the file in \code{dest}) and \code{there} (the name of the
file in the packet)
}
}
\description{
Copy files from a packet to anywhere. Similar to
\code{\link[=orderly_dependency]{orderly_dependency()}} except that this is not used in an
active packet context. You can use this function to pull files
from an outpack root to a directory outside of the control of
outpack, for example. Note that all arguments need must be
provided by name, not position, with the exception of the id or
query.
}
\details{
You can call this function with an id as a string, in which case
we do not search for the packet and proceed regardless of whether
or not this id is present.  If called with any other arguments
(e.g., a string that does not match the id format, or a named
argument \code{name}, \code{subquery} or \code{parameters}) then we interpret the
arguments as a query and \code{\link[=orderly_search]{orderly_search()}} to find the
id. It is an error if this query does not return exactly one
packet id, so you probably want to use \code{latest()}.

There are different ways that this might fail (or recover from
failure):
\itemize{
\item if \code{id} is not known in the metadata store (not known because
it's not unpacked but also not known to be present in some other
remote) then this will fail because it's impossible to resolve
the files. Consider refreshing the metadata with
\code{\link[=orderly_location_fetch_metadata]{orderly_location_fetch_metadata()}} to refresh this.
\item if the \code{id} is not unpacked \emph{and} no local copy of the files
referred to can be found, we error by default (but see the next
option). However, sometimes the file you refer to might also be
present because you have downloaded a packet that depended on
it, or because the content of the file is unchanged because from
some other packet version you have locally.
\item if the \code{id} is not unpacked, there is no local copy of the file
and if \code{allow_remote} is \code{TRUE} we will try and request the file
from whatever remote would be selected by
\code{\link[=orderly_location_pull]{orderly_location_pull()}} for this packet.
}

Note that empty directories might be created on failure.
}
\examples{
root <- orderly_example()
orderly_run("data", root = root)

dest <- withr::local_tempdir()
res <- orderly_copy_files("latest", name = "data", "data.rds",
                          dest = dest, root = root)

# We now have our data in the destination directory:
fs::dir_tree(dest)

# Information about the copy:
res
}
