% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cranDownloads.R
\name{plot.cranDownloads}
\alias{plot.cranDownloads}
\title{Plot method for cranDownloads().}
\usage{
\method{plot}{cranDownloads}(x, statistic = "count", graphics = "auto",
  points = "auto", log.y = FALSE, smooth = FALSE, se = FALSE,
  f = 1/3, span = 3/4, package.version = FALSE, r.version = FALSE,
  population.plot = FALSE, population.seed = as.numeric(Sys.Date()),
  multi.plot = FALSE, same.xy = TRUE, legend.location = "topleft",
  ip.legend.location = "topright", r.total = FALSE, dev.mode = FALSE,
  unit.observation = "day", chatgpt = "line", weekend = FALSE,
  multi.core = FALSE, ...)
}
\arguments{
\item{x}{object.}

\item{statistic}{Character. "count" or "cumulative".}

\item{graphics}{Character. "auto", "base" or "ggplot2".}

\item{points}{Character of Logical. Plot points. "auto", TRUE, FALSE.}

\item{log.y}{Logical. Logarithm of package downloads.}

\item{smooth}{Logical. Add smoother.}

\item{se}{Logical. Works only with graphics = "ggplot2".}

\item{f}{Numeric. smoother window for stats::lowess(). For graphics = "base" only; c.f. stats::lowess(f)}

\item{span}{Numeric. Smoothing parameter for geom_smooth(); c.f. stats::loess(span).}

\item{package.version}{Logical or "line". Add package release dates and vertical lines.}

\item{r.version}{Logical or "line". Add R release dates and vertical lines.}

\item{population.plot}{Logical. Plot population plot.}

\item{population.seed}{Numeric. Seed for sample in population plot.}

\item{multi.plot}{Logical.}

\item{same.xy}{Logical. Use same scale for multiple packages when graphics = "base".}

\item{legend.location}{Character.}

\item{ip.legend.location}{Character. Location of in-progress legend.}

\item{r.total}{Logical.}

\item{dev.mode}{Logical. Use packageHistory0() to scrape CRAN.}

\item{unit.observation}{Character. "year", "month", "week", or "day".}

\item{chatgpt}{Logical or "line". Add intitial availability date and vertical line for ChatGPT.}

\item{weekend}{Logical. Highlight weekends (pch = 1) when unit.observation = "day".}

\item{multi.core}{Logical or Numeric. \code{TRUE} uses \code{parallel::detectCores()}. \code{FALSE} uses one, single core. You can also specify the number logical cores. Mac and Unix only.}

\item{...}{Additional plotting parameters.}
}
\value{
A base R or ggplot2 plot.
}
\description{
Plot method for cranDownloads().
}
\examples{
\dontrun{
plot(cranDownloads(packages = c("Rcpp", "rlang", "data.table")))
plot(cranDownloads(packages = c("Rcpp", "rlang", "data.table"), when = "last-month"))
plot(cranDownloads(packages = "R", from = "2020-01-01", to = "2020-01-01"))
plot(cranDownloads(packages = "R", from = 2020))
}
}
