% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_genomatrix.R
\name{getGenotypes}
\alias{getGenotypes}
\title{Genotype matrix}
\usage{
getGenotypes(
  x,
  ids = NULL,
  markers = NULL,
  sep = "/",
  missing = "-",
  Xchrom = NULL
)
}
\arguments{
\item{x}{A \code{ped} object or a list of such.}

\item{ids}{A vector of ID labels, or a function operating on \code{x}, e.g.,
\code{\link[=typedMembers]{typedMembers()}}. By default (\code{ids = NULL}) all individuals are included,
also non-genotyped ones.}

\item{markers}{A vector of indices or names of markers attaches to \code{x}. If
NULL (default) all markers are included.}

\item{sep}{A single string to be used as allele separator in marker
genotypes.}

\item{missing}{A single string to be used for missing alleles.}

\item{Xchrom}{A single logical, or NULL (default). May be used to indicate if
all (or none) markers are on X, if this is known in advance.}
}
\value{
\code{getGenotypes()} returns a character matrix with \code{length(ids)} rows and
\code{length(markers)} columns.
}
\description{
Extract the genotypes of specified individuals and markers from a pedigree
object, and return them as a character matrix.
}
\examples{
x = nuclearPed() |>
  addMarker(`2` = "1/2", name = "m1") |>
  addMarker(`3` = "a/a", name = "m2")

getGenotypes(x)

### A list of pedigrees

s = transferMarkers(x, singleton("s"))
peds = list(x, s)

getGenotypes(peds)

# Using a function to select individuals
getGenotypes(x, ids = typedMembers)

}
\seealso{
\code{\link[=getAlleles]{getAlleles()}}
}
