% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{consistency_const}
\alias{consistency_const}
\alias{efficiency_const}
\title{Get the Constant for Consistency for the M-Scale and for Efficiency
for the M-estimate of Location}
\usage{
consistency_const(delta, rho, eps = sqrt(.Machine$double.eps))

efficiency_const(eff, rho, eps = sqrt(.Machine$double.eps))
}
\arguments{
\item{delta}{desired breakdown point (between 0 and 0.5)}

\item{rho}{the name of the chosen \eqn{\rho} function.
See \code{\link[=rho_function]{rho_function()}} for a list of supported functions.}

\item{eps}{numerical tolerance level for equality comparisons}

\item{eff}{desired asymptotic efficiency (between 0.1 and 0.99).}
}
\value{
consistency constant
}
\description{
Returns the tuning constants required to achieve the desired
breakdown point or efficiency under the Normal model.
}
\seealso{
Other Robustness control options: 
\code{\link{mscale_algorithm_options}()},
\code{\link{rho_function}()}

Other Robustness control options: 
\code{\link{mscale_algorithm_options}()},
\code{\link{rho_function}()}
}
\concept{Robustness control options}
