% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es.fsq.partial.R
\name{es.fsq.partial}
\alias{es.fsq.partial}
\title{Cohen f-squared effect size for partial F test in multiple linear regression}
\usage{
es.fsq.partial(Rsq.red = NULL, Rsq.full = NULL, Rsq.diff = NULL, pc = NULL)
}
\arguments{
\item{Rsq.red}{The squared population multiple correlation coefficient for the reduced model. Either 2 out of 3 Rsq terms OR pc must be specified.}

\item{Rsq.full}{The squared population multiple correlation coefficient for the full model. Either 2 out of 3 Rsq terms OR pc must be specified.}

\item{Rsq.diff}{The difference between the squared population multiple correlation coefficient for the full model and the reduced model. Either 2 out of 3 Rsq terms OR pc must be specified.}

\item{pc}{The partial correlation coefficient. Either 2 out of 3 Rsq terms OR pc must be specified.}
}
\value{
A list of the arguments and the f^2 effect size.
}
\description{
Computes the f-squared (f^2) effect size for a partial F test in a multiple linear regression model
using either model R^2 (Rsq) values or a partial correlation. Based on Cohen (1988). (EDIT THIS)
}
\details{
Cohen J (1988) Statistical Power Analysis for the Behavioral Sciences, 2nd edition.
Lawrence Erlbaum Associates, Hillsdale, New Jersey
}
\examples{
es.fsq.partial(pc = 0.2)
es.fsq.partial(Rsq.red = 0.25, Rsq.full = 0.35)
es.fsq.partial(Rsq.red = 0.25, Rsq.diff = 0.1)
es.fsq.partial(Rsq.full = 0.35, Rsq.diff = 0.1)
}
