% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_match_genus.R
\name{fuzzy_match_genus}
\alias{fuzzy_match_genus}
\title{Fuzzy Match Genus Name}
\usage{
fuzzy_match_genus(
  df,
  target_df = NULL,
  max_dist = 2,
  save_ambiguous = FALSE,
  ambiguous_path = "ambiguous_genera.csv"
)
}
\arguments{
\item{df}{A tibble containing the genus names to be matched.}

\item{target_df}{A tibble representing the ppendemic database containing the reference list of endemic species.}

\item{max_dist}{Maximum edit distance used by fuzzyjoin::stringdist_* joins.}

\item{save_ambiguous}{Logical flag. If \code{TRUE}, ambiguous fuzzy genus matches
are exported to disk.}

\item{ambiguous_path}{File path used when \code{save_ambiguous = TRUE}. Defaults
to \code{"ambiguous_genera.csv"}.}
}
\value{
A tibble with two additional columns:
\itemize{
\item fuzzy_match_genus: A logical column indicating whether the genus was successfully matched (\code{TRUE}) or not (\code{FALSE}).
\item fuzzy_genus_dist: A numeric column representing the distance for each match.
}
}
\description{
This function performs a fuzzy match of genus names against the ppendemic database using fuzzyjoin::stringdist() to account for slight variations in spelling.
}
\keyword{internal}
