% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_priorsense_data.R
\name{create-priorsense-data}
\alias{create-priorsense-data}
\alias{create_priorsense_data}
\alias{create_priorsense_data.default}
\alias{create_priorsense_data.stanfit}
\alias{create_priorsense_data.CmdStanFit}
\alias{create_priorsense_data.draws}
\alias{create_priorsense_data.rjags}
\title{Create data structure for priorsense}
\usage{
create_priorsense_data(x, ...)

\method{create_priorsense_data}{default}(
  x,
  fit = NULL,
  log_prior_fn = log_prior_draws,
  log_lik_fn = log_lik_draws,
  log_prior = NULL,
  log_lik = NULL,
  log_ratio_fn = NULL,
  log_prior_name = "lprior",
  log_lik_name = "log_lik",
  ...
)

\method{create_priorsense_data}{stanfit}(x, ...)

\method{create_priorsense_data}{CmdStanFit}(x, ...)

\method{create_priorsense_data}{draws}(x, ...)

\method{create_priorsense_data}{rjags}(x, ...)
}
\arguments{
\item{x}{an object for which the method is defined or an object
coercible to a \code{posterior::draws} object}

\item{...}{arguments passed to methods}

\item{fit}{a model fit object (only used if x is not a fit object)}

\item{log_prior_fn}{function to derive log prior from x or fit (if
not NULL)}

\item{log_lik_fn}{function to derive log likelihood from x or fit
(if not NULL)}

\item{log_prior}{draws object from log prior, must be numeric and
not include NA, NaN, Inf, -Inf or be constant}

\item{log_lik}{draws from log likelihood, must be numeric and not
include NA, NaN, Inf, -Inf or be constant}

\item{log_ratio_fn}{function for moment matching}

\item{log_prior_name}{Character (case sensitive) specifying name of the variable storing the log prior evaluations}

\item{log_lik_name}{Character (case sensitive) specifying name of the variable storing the log likelihood evaluations}
}
\value{
A \code{priorsense_data} object, which contains the data and
functions to run sensitivity analyses.
}
\description{
Create a data structure that contains all required data and
functions for priorsense
}
\examples{
x <- example_powerscale_model()
drw <- x$draws

psd <- create_priorsense_data(drw)
}
