% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.pwrrasch.R
\name{summary.pwrrasch}
\alias{summary.pwrrasch}
\title{Object Summary}
\usage{
\method{summary}{pwrrasch}(object, ...)
}
\arguments{
\item{object}{\code{pwrrasch} object}

\item{...}{Additional arguments affecting the summary produced.}
}
\description{
Generic \code{summary} function for the \code{pwrrasch} object
}
\examples{
\dontrun{

# item parameters
ipar2 <- ipar1 <- seq(-3, 3, length.out = 20)
# model differential item function (DIF)
ipar2[9] <- ipar1[12]
ipar2[12] <- ipar1[9]
# simulation for b = 100 
simres <- pwr.rasch(100, ipar = list(ipar1, ipar2))
summary(simres)

# item parameters
ipar2 <- ipar1 <- seq(-3, 3, length.out = 20)
# model differential item function (DIF)
ipar2[10] <- ipar1[11]
ipar2[11] <- ipar1[10]
# simulation for b = 100, 200, 300, 400, 500 
simres <- pwr.rasch(seq(100, 500, by = 100), ipar = list(ipar1, ipar2))
summary(simres)
}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at},
Jan Steinfeld \email{jan.steinfeld@univie.ac.at}
}
