% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_master.R
\name{build_master}
\alias{build_master}
\title{Build a Master Script From Folder}
\usage{
build_master(
  dir,
  master_name = "Master",
  author = "",
  with_structure = TRUE,
  with_run_all = TRUE,
  with_run_folder = TRUE
)
}
\arguments{
\item{dir}{The folder structure which contains the scripts to build upon.}

\item{master_name}{The file name which should be written.}

\item{author}{Authors name to be put in the header.}

\item{with_structure}{Whether the folder structure as tree should be written
to the master script.}

\item{with_run_all}{Whether a section, which let's the user run all scripts,
should be written to the master script.}

\item{with_run_folder}{Whether a section, which let's the user run all scripts from a
specific folder, should be written to the master script.}
}
\value{
Returns the script as character vector and saves it as markdown file.
}
\description{
\code{\link[=build_master]{build_master()}} reads a given folder structure, which contains scripts, and builds
a master script as a markdown file.
}
\details{
The function works with folder structures that look like this:

root/

\if{html}{\out{<div class="sourceCode">}}\preformatted{ subfolder1/

     script1.R

     script2.R

     ....R

 subfolder2/

     script3.R

     script4.R

     ....R

 .../

     ....R
}\if{html}{\out{</div>}}
}
\examples{
# Example export file paths
# NOTE: These tempfiles are only for the examples. In reality you just call the
# main function and put in your desired path and name directly.
temp_file <- tempfile(fileext = ".rstheme")
file_name <- basename(tools::file_path_sans_ext(temp_file))

# Example master
build_master(dir         = dirname(temp_file),
             master_name = file_name)

# Manual cleanup for example
unlink(temp_file)

}
