% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strings.R
\name{concat}
\alias{concat}
\title{Concatenate Multiple Variables With Padding}
\usage{
concat(
  data_frame,
  ...,
  padding_char = NULL,
  padding_length = NULL,
  padding_right = FALSE
)
}
\arguments{
\item{data_frame}{A data frame which contains the the variables to concatenate.}

\item{...}{The names of the variables to concatenate.}

\item{padding_char}{A single character which will be used to fill up the empty places.}

\item{padding_length}{A numeric vector containing the individual padding length per variable.}

\item{padding_right}{FALSE by default. If TRUE insert padding characters on the right side
instead of the left side.}
}
\value{
Returns a character vector.
}
\description{
Concatenate multiple variables inside a data frame into a new variable. An
automatic or individual padding can be applied. The padding character can be
chosen freely.

The function can also be used to give a single variable a padding.
}
\examples{
# Example data frame
my_data <- dummy_data(100)

# Concatenate variables as provided
my_data[["id1"]] <- my_data |> concat(household_id, state, age)

# Concatenate variables with leading zeros. Each variable will
# receive an individual padding length according to their
# longest value.
my_data[["id2"]] <- my_data |> concat(household_id, state, age,
                                      padding_char = "0")

# Concatenate variables with individual character and lengths.
my_data[["id2"]] <- my_data |> concat(household_id, state, age,
                                      padding_char   = "_",
                                      padding_length = c(5, 3, 4))

# Padding a single variable in place
my_data[["state"]] <- my_data |> concat(state, padding_char = "0")

}
\seealso{
Other character manipulating functions: \code{\link[=sub_string]{sub_string()}}, \code{\link[=remove_blanks]{remove_blanks()}}
}
