% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trail_compare.R
\name{trail_icr}
\alias{trail_icr}
\title{Compute inter-rater reliability across Trail settings (deprecated)}
\usage{
trail_icr(
  x,
  id_col = "id",
  label_col = "label",
  min_coders = 2L,
  icr_fun = validate,
  ...
)
}
\arguments{
\item{x}{A \code{trail_compare} object or a list of \code{trail_record}
objects.}

\item{id_col}{Character scalar. Name of the unit identifier column in
the resulting wide data (defaults to "id").}

\item{label_col}{Character scalar. Name of the label column in each
record's annotations (defaults to "label").}

\item{min_coders}{Integer. Minimum number of non-missing coders per
unit required for inclusion.}

\item{icr_fun}{Function used to compute inter-rater reliability.
Defaults to \code{validate()}, which is expected to accept
\code{data}, \code{id}, \code{coder_cols}, \code{min_coders},
and \code{mode = "icr"}. It should also understand
\code{output = "list"} to return a named list of statistics.}

\item{...}{Additional arguments passed on to \code{icr_fun}.}
}
\value{
The result of calling \code{icr_fun()} on the wide data.
With the default \code{validate()}, this is a named list of
inter-rater reliability statistics.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\details{
\code{trail_icr()} is deprecated. Use \code{\link[=qlm_compare]{qlm_compare()}} to compute inter-rater
reliability across multiple coded objects.
}
\seealso{
\itemize{
\item \code{trail_compare()} – run the same task across multiple settings
\item \code{trail_matrix()} – underlying wide data used here
\item \code{validate()} – core validation / ICR engine
}
}
\keyword{internal}
