% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoring_primitives.R
\name{normalize_01}
\alias{normalize_01}
\title{Normalize to 0--1 Range}
\usage{
normalize_01(x, direction = c("higher_better", "lower_better"), clamp = TRUE)
}
\arguments{
\item{x}{Numeric vector.}

\item{direction}{Character. \code{"higher_better"} (default) maps max to 1;
\code{"lower_better"} maps min to 1.}

\item{clamp}{Logical. If \code{TRUE}, clamp output to [0, 1].}
}
\value{
Numeric vector normalized to 0--1.
}
\description{
Applies min-max normalization to a numeric vector, optionally clamping
values to [0, 1].
}
\examples{
normalize_01(c(10, 20, 30, 40, 50))
normalize_01(c(10, 20, 30), direction = "lower_better")

}
