% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rarify.R
\name{rarify}
\alias{rarify}
\title{Rarify Depth Data}
\usage{
rarify(outline, df, x, y, z, res = 10, crsUnits = "dd")
}
\arguments{
\item{outline}{shapefile outline of a waterbody}

\item{df}{dataframe of coordinates and depths for a given waterbody}

\item{x}{character giving name of longitude column}

\item{y}{character giving name of latitude column}

\item{z}{character giving name of depth column}

\item{res}{number describing by how much to increase point resolution, default = 10}

\item{crsUnits}{character describing CRS units of input outline, either "dd" (decimal degrees) or "m" (meters), default = "dd"}
}
\value{
dataframe of rarified xyz coordinates
}
\description{
Reduce density of mapped depth data to improve accuracy and computation time.
}
\examples{
#load test data
outline <- terra::vect(system.file("extdata", "example_outline.shp", package = 'rLakeHabitat'))
depths <- read.csv(system.file("extdata", "example_depths.csv", package = 'rLakeHabitat'))
#run function
rarify(outline = outline, df = depths, x = "x", y = "y", z = "z", res = 100, crsUnits = "dd")
}
\author{
Sean Bertalot & Tristan Blechinger, Department of Zoology & Physiology, University of Wyoming
}
