% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.r
\name{fitflowvariational}
\alias{fitflowvariational}
\title{Fit a Flow-Based Variational Posterior for Sanov Inference}
\usage{
fitflowvariational(
  observed,
  states = NULL,
  flowtype = c("maf", "splinepwlin", "planar", "radial"),
  flowspec = list(),
  inittheta = NULL,
  pxgivenz,
  nmc = 256,
  control = list()
)
}
\arguments{
\item{observed}{Observed empirical distribution Q (probability vector).}

\item{states}{Optional vector of category names.}

\item{flowtype}{One of "maf", "splinepwlin", "planar", "radial".}

\item{flowspec}{A list specifying structural parameters (d, K, etc.).}

\item{inittheta}{Optional initial parameter vector for trainable flows.}

\item{pxgivenz}{A function mapping latent z to a categorical pmf.}

\item{nmc}{Number of Monte Carlo samples for ELBO estimation.}

\item{control}{List of control parameters passed to \code{optim()}.}
}
\value{
A list containing:
\itemize{
\item flow: the fitted flow model
\item elbo: final ELBO value
\item theta: optimized parameter vector (if applicable)
\item convergence: optim() convergence code
}
}
\description{
This function fits a variational posterior q(z) using a chosen normalizing flow.
The objective is the ELBO:
}
\details{
\eqn{\log p(x | z) + \log p(z) - \log q(z)}

The flow parameters (theta) are optimized via \code{optim()} when applicable
(MAF and spline flows). Planar and radial flows have no trainable parameters.

This function performs generic variational inference using a chosen
normalizing flow and a user-provided likelihood \code{pxgivenz}.

For specialized rare-event inference using:
\itemize{
\item Girsanov change of measure
\item Freidlin–Wentzell quasi-potential
}

see the wrapper functions:
\itemize{
\item \code{fitflow_girsanov()}
\item \code{fitflow_FW()}
}

These wrappers construct a tilted likelihood and then call
\code{fitflowvariational()} internally.
}
