test_that("can access model fit features ", {
  ## Annette Dobson (1990)
  ## "An Introduction to Generalized Linear Models".
  ## Page 9: Plant Weight Data.
  ctl <- c(4.17,5.58,5.18,6.11,4.50,4.61,5.17,4.53,5.33,5.14)
  trt <- c(4.81,4.17,4.41,3.59,5.87,3.83,6.03,4.89,4.32,4.69)
  dobson <- data.frame(
    weight = c(ctl, trt),
    group = gl(2, 10, 20, labels = c("Ctl","Trt")),
    one = 1)
  lm_fit <- lm(weight ~ 1 + group, data = dobson)
  rbc_fit <- rbc(weight ~ 1 | 0 + offset(one) | 1 + group,
    init = Normal(0, 1),
    flows = list(Scale, Translate, Translate),
    data = dobson)
  expect_equal(
    logLik(rbc_fit)[1], logLik(lm_fit)[1])
  expect_equal(
    AIC(rbc_fit), AIC(lm_fit))
  predframe <- data.frame(
    group = factor(c("Ctl", "Trt")),
    one = 1)
  expect_equal(
    as.vector(predict(rbc_fit, newdata = predframe)),
    as.vector(predict(lm_fit, newdata = predframe)))
})
